<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:p="http://www.sec.gov/edgar/ta/tatwofiler">

	<xsl:template name="item1_serviceCompanyInfo">
		<h1><xsl:value-of select="$submissionType"/>: Service Company Information</h1>
       <table role="presentation" >
			<tr>
				<td class="label">
					<font color="black">
						<b>2(a).</b> During the reporting period, has a Registrant engaged a service company to perform any of its transfer agent functions: 
					</font>
				</td>
				<td>
					<div style="FONT-WEIGHT: normal" align="left">
							
						<xsl:choose>
							<xsl:when
								test="contains(p:formData/p:engagedServiceCompany/p:serviceCompany , 'All')">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>&#160;<font color="black">All</font>&#160;
				
						
					<xsl:choose>
						<xsl:when
							test="contains(p:formData/p:engagedServiceCompany/p:serviceCompany , 'Some')">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>&#160;<font color="black">Some</font>&#160;
						
							
						<xsl:choose>
							<xsl:when
								test="contains(p:formData/p:engagedServiceCompany/p:serviceCompany , 'None')">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>&#160;<font color="black">None</font>&#160;
						
					</div>
				</td>			
			</tr>
			</table>			
		 <table role="presentation" >					
			<xsl:if test="p:formData/p:engagedServiceCompany/p:serviceCompany = 'All' or p:formData/p:engagedServiceCompany/p:serviceCompany = 'Some'">		
				<tr>
					<td>
						<b>2(b).</b> If the answer to subsection (a) is all or some, provide the name(s)
						and transfer agent file number(s) of all service company(ies)
						engaged:
					</td>
				</tr>			
				<table class="xdLayout" style="BORDER-RIGHT: medium none; TABLE-LAYOUT: fixed; BORDER-TOP: medium none; BORDER-LEFT: medium none; WIDTH: 982px; BORDER-BOTTOM: medium none; BORDER-COLLAPSE: collapse; WORD-WRAP: break-word" borderColor="buttontext" border="1">
					<colgroup>
						<col style="WIDTH: 800px"></col>
						<col style="WIDTH: 182px"></col>				
					</colgroup>
					<tbody vAlign="top">
						<tr>
							<td class= "fakeBox6" style="font-size:0.9em">
								<div align="left" color ="black">									
									<b>Name of Transfer Agent(s):</b>									
								</div>
							</td>
							<td class= "fakeBox6" style="font-size:0.9em">
								<div align="left" color ="black">
									<b>File Number:</b>															
								</div>
							</td>
						</tr>
					</tbody>
					<tbody>
						<xsl:for-each select="p:formData/p:engagedServiceCompany/p:serviceCompanyTransferAgent">
							<tr>
								<td class="fakeBox6">
									<div class="h1a">					
										<xsl:value-of select="p:entityName" />								
									</div>
								</td>						
								<td class="fakeBox6" style="font-size:0.9em">
								  <xsl:call-template name="FileNoLink" >
									 <xsl:with-param name="aFileNumber" select="p:fileNumber"></xsl:with-param>
									 <xsl:with-param name="label" select="p:fileNumber"></xsl:with-param>							
								  </xsl:call-template>
								</td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
			</xsl:if>
			</table>
			
			<table role="presentation" >
				<tr>
					<td class="label"><b>2(c).</b> During the reporting period, has the Registrant been engaged as a service company by a named transfer agent to perform transfer agent functions?</td>
					<td>							
						<xsl:choose>
							<xsl:when test="p:formData/p:engagedServiceCompany/p:registrantEngagedService = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes
						<xsl:choose>
							<xsl:when test="p:formData/p:engagedServiceCompany/p:registrantEngagedService = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No							
					</td>
				</tr>
			</table>
		
		<table role="presentation" >
			<xsl:if test="p:formData/p:engagedServiceCompany/p:registrantEngagedService = 'Y'">				
				<tr>
					<td>
						<b>2(d).</b> If the answer to subsection (c) is yes, provide the name(s) and file number(s) 
				of the named transfer agent(s) for which the Registrant has been engaged 
				as a service company to perform transfer agent functions:
					</td>
				</tr>			
				<table class="xdLayout" style="BORDER-RIGHT: medium none; TABLE-LAYOUT: fixed; BORDER-TOP: medium none; BORDER-LEFT: medium none; WIDTH: 982px; BORDER-BOTTOM: medium none; BORDER-COLLAPSE: collapse; WORD-WRAP: break-word" borderColor="buttontext" border="1">
					<colgroup>
						<col style="WIDTH: 800px"></col>
						<col style="WIDTH: 182px"></col>				
					</colgroup>
					<tbody vAlign="top">
						<tr>
							<td class= "fakeBox6" style="font-size:0.9em">
								<div align="left" >
									<b>Name of Transfer Agent(s):</b>
								</div>
							</td>
							<td class= "fakeBox6" style="font-size:0.9em">
								<div align="left">
									<b>File Number:</b>															
								</div>
							</td>
						</tr>
					</tbody>
					<tbody>
						<xsl:for-each select="p:formData/p:engagedServiceCompany/p:asServiceCompanyTransferAgent">
							<tr>
								<td class="fakeBox6">
									<div class="h1a">
										<xsl:value-of select="p:entityName" />																	
									</div>
								</td>						
								<td class="fakeBox6" style="font-size:0.9em">
								  <xsl:call-template name="FileNoLink" >
									 <xsl:with-param name="aFileNumber" select="p:fileNumber"></xsl:with-param>
									 <xsl:with-param name="label" select="p:fileNumber"></xsl:with-param>							
								  </xsl:call-template>
								</td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
			</xsl:if>
		</table>
		
	</xsl:template>	
</xsl:stylesheet>